<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'invoice';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function lines()
    {
        return $this->morphMany('App\Models\Finance\Line', 'lineable');
    }

    public function customer()
    {
        return $this->belongsTo('App\Models\Person\Person', 'customer_id');
    }

    public function supplier()
    {
        return $this->belongsTo('App\Models\Person\Person', 'supplier_id');
    }

    public function currency()
    {
        return $this->belongsTo('App\Models\Finance\Currency', 'currency_id');
    }

    public function reonciliations()
    {
        return $this->hasMany('App\Models\Finance\InvoiceReconciliation', 'invoice_id');
    }

    public function financial_period()
    {
        return $this->belongsTo('App\Models\Finance\FinancialPeriod', 'financial_period_id');
    }

    public function costCode()
    {
        return $this->belongsTo('App\Models\Finance\CostCode', 'cost_code_id');
    }

}